/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.core.attachments;

import filenet.vw.api.VWAttachment;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.core.attachments.VWAttachmentHelper;
import filenet.vw.toolkit.runtime.step.core.attachments.VWIDMIcon;
import filenet.vw.toolkit.runtime.step.core.attachments.VWIDMItem;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class VWIDMItemRenderer
extends JLabel
implements TableCellRenderer {
    private ImageIcon m_blankIcon = null;
    private ImageIcon m_checkIcon = null;
    private ImageIcon m_docIcon = null;
    private ImageIcon m_folderIcon = null;
    private ImageIcon m_questionIcon = null;
    private ImageIcon m_siconhtmlIcon = null;
    private ImageIcon m_storedIcon = null;

    public VWIDMItemRenderer() {
        this.setOpaque(true);
        this.m_blankIcon = this.loadIcon("blank.gif");
        this.m_checkIcon = this.loadIcon("check.gif");
        this.m_docIcon = this.loadIcon("docicon.gif");
        this.m_folderIcon = this.loadIcon("folder.gif");
        this.m_questionIcon = this.loadIcon("question.gif");
        this.m_siconhtmlIcon = this.loadIcon("siconhtml.gif");
        this.m_storedIcon = this.loadIcon("stored.gif");
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean isCheckedout = false;
        VWIDMIcon idmIcon = null;
        String description = null;
        VWAttachment attachment = null;
        try {
            if (value == null) {
                return this;
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
                this.setFont(table.getFont());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
                this.setFont(table.getFont());
            }
            if (value instanceof VWIDMItem) {
                this.setText(((VWIDMItem)value).getDisplayName());
                attachment = ((VWIDMItem)value).getAttachment();
                if (attachment != null) {
                    description = attachment.getAttachmentDescription();
                    if (description != null && description.length() == 0) {
                        description = null;
                    }
                    this.setToolTipText(description);
                    idmIcon = new VWIDMIcon(this.m_blankIcon, this.m_blankIcon);
                    switch (attachment.getType()) {
                        case 3: {
                            idmIcon.setTypeIcon(this.m_docIcon);
                            try {
                                VWAttachmentHelper vwAttachmentHelper = ((VWIDMItem)value).getAttachmentHelper();
                                if (vwAttachmentHelper != null && vwAttachmentHelper.isCheckedOut()) {
                                    idmIcon.setCheckedOutIcon(this.m_checkIcon);
                                    break;
                                }
                                idmIcon.setCheckedOutIcon(this.m_blankIcon);
                            }
                            catch (Exception ex) {
                                idmIcon.setCheckedOutIcon(this.m_questionIcon);
                            }
                            break;
                        }
                        case 2: {
                            idmIcon.setTypeIcon(this.m_folderIcon);
                            break;
                        }
                        case 4: {
                            idmIcon.setTypeIcon(this.m_storedIcon);
                            break;
                        }
                        case 5: {
                            idmIcon.setTypeIcon(this.m_siconhtmlIcon);
                        }
                    }
                }
                this.setIcon(idmIcon);
            } else if (value instanceof String) {
                this.setText((String)value);
                this.setIcon(null);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this;
    }

    protected ImageIcon loadIcon(String iconName) {
        URL iconUrl = null;
        ImageIcon icon = null;
        try {
            iconUrl = this.getClass().getResource("images/" + iconName);
            if (iconUrl != null) {
                icon = new ImageIcon(iconUrl);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
        return icon;
    }
}

